<?php

namespace AppBundle\Form\Type;


use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ContactFormType extends AbstractType {

    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder->add('lastName', 'text', array(
            'required' => false,
            'label' => 'CONTACT_FORM_LASTNAME'
        ));
        $builder->add('firstName', 'text', array(
            'required' => false,
            'label' => 'CONTACT_FORM_FIRSTNAME'
        ));
        $builder->add('email', 'text', array(
            'required' => true,
            'label' => 'CONTACT_FORM_EMAIL'
        ));
        $builder->add('subject', 'text', array(
            'required' => true,
            'label' => 'CONTACT_FORM_SUBJECT'
        ));
        $builder->add('message', 'textarea', array(
            'required' => true,
            'label' => 'CONTACT_FORM_MESSAGE'
        ));
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => "AdminBundle\Entity\Contact"
        ));
    }

    public function getName()
    {
        return 'site_contact_form';
    }


}